//
//  MCReportNamedImagePicker.h
//  MCReporting
//
//  Created by Alykhan Jetha on 24/03/06.
//  Copyright 2006 Marketcircle Inc.. All rights reserved.
//

#import <MCApplication/MCWindowController.h>


@interface MCReportNamedImagePicker : MCWindowController {

	IBOutlet NSImageView *imageView;
	IBOutlet NSObjectController *objectController;
	
	IBOutlet NSTextField *campareValueField;
	IBOutlet NSTextField *compareValueLabel;

	id (delegate);
	
	NSString *selectedImageName;
	id compareValue;
	BOOL doesNotRequiresCompareValue;
}

- (NSArray *)availableImageNames;

- (void)setDelegate:(id)aDeleg;

- (NSString *)selectedImageName;
- (void)setSelectedImageName:(NSString *)aSelectedImageName;

- (id)compareValue;
- (void)setCompareValue:(id)aCompareValue;

- (BOOL)doesNotRequiresCompareValue;
- (void)setDoesNotRequiresCompareValue:(BOOL)flag;

- (IBAction)ok:(id)sender;
- (IBAction)cancel:(id)sender;

@end


@interface NSObject (MCReportNamedImagePickerDelegate)
- (void)namedImagePicker:(MCReportNamedImagePicker *)aPicker didSelectImageName:(NSString *)aName comparisonValue:(id)aValue;
@end

